import numpy as np
import matplotlib.pyplot as plt
from define_edl_system import *
from subfunctions_EDL import *
from define_planet import *
from define_mission_events import *

# *************************************
# load dicts that define the EDL system (includes rover), planet,
# mission events and so forth.

diam = np.arange(14,19.5, 0.5)
sim_time = []
rover_speed = []
success = []
for i in range(len(diam)):
    edl_system = define_edl_system_1()
    mars = define_planet()
    mission_events = define_mission_events()
    edl_system['altitude'] = 11000  # [m] initial altitude
    edl_system['velocity'] = -587  # [m/s] initial velocity
    edl_system['parachute']['deployed'] = True  # our parachute is open
    edl_system['parachute']['ejected'] = False  # and still attached
    edl_system['rover']['on_ground'] = False  # the rover has not yet landed
    tmax = 2000  # [s] maximum simulated time
    edl_system['parachute']['diameter'] = diam[i]
    [t, Y, edl_system] = simulate_edl(edl_system, mars, mission_events, tmax, True)
    time_val = t[-1]
    speed_val = edl_system['velocity']
    if (edl_system['rover']['on_ground'] == True) and (abs(speed_val) <= 1) and (edl_system['altitude'] >= 4.5):
        success_val = 1
    else:
        success_val = 0
    sim_time.append(time_val)
    rover_speed.append(speed_val)
    success.append(success_val)

plt.figure(0)
fig, axs = plt.subplots(3)
axs[0].plot(diam, sim_time)
axs[0].set_title('Simulated Time vs. Parachute Diameter')
axs[0].set_xlabel('Parachute Diameter (m)')
axs[0].set_ylabel('Simulated Time (s)')
axs[0].grid()
axs[1].plot(diam,rover_speed)
axs[1].set_title('Rover speed vs. Parachute Diameter')
axs[1].set_xlabel('Parachute Diameter (m)')
axs[1].set_ylabel('Rover speed (m/s)')
axs[1].grid()
axs[2].plot(diam,success)
axs[2].set_title('Rover landing Success vs. Parachute Diameter')
axs[2].set_xlabel('Parachute Diameter (m)')
axs[2].set_ylabel('Rover Landing Success')
axs[2].grid()
fig.tight_layout(pad=1.5)
plt.show()
